/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs;

import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.fcs.MachineId;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;

public class FcsEvent
extends EventObject {
    public static final int TYPE_MACHINE_EVENT = 1;
    public static final int TYPE_SERVICE_EVENT = 2;
    public static final int TYPE_FCS_EVENT = 3;
    public static final int MACHINE_ADDED = 51;
    public static final int MACHINE_REMOVED = 52;
    public static final int MACHINE_RECYCLED = 53;
    public static final int MACHINE_CHANGED = 54;
    public static final int SERVICE_ADDED = 100;
    public static final int SERVICE_REMOVED = 101;
    public static final int FCS_SERVER_STOPPED = 150;
    public static final int FCS_SERVER_RESTARTED = 151;
    private int eventType;
    private int eventDetails;
    private MachineId machineId;
    private MachineId oldMachineId;
    private Set services;

    public FcsEvent(int eventType, int eventDetails, MachineId machineId, Set services) {
        super(machineId);
        this.eventType = eventType;
        this.eventDetails = eventDetails;
        this.machineId = machineId;
        this.services = services;
    }

    public FcsEvent(int eventType, int eventDetails, MachineId machineId, MachineId oldMachineId, Set services) {
        this(eventType, eventDetails, machineId, services);
        this.oldMachineId = oldMachineId;
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getEventDetails() {
        return this.eventDetails;
    }

    public MachineId getMachineId() {
        return this.machineId;
    }

    public MachineId getOldMachineId() {
        return this.oldMachineId;
    }

    public Set getServices() {
        return this.services;
    }

    public String toString() {
        String returnString = "FcsEvent--";
        if (this.eventType == 1) {
            returnString = returnString + "Type: Machine Event";
        } else if (this.eventType == 2) {
            returnString = returnString + "Type: Service Event";
        } else if (this.eventType == 3) {
            returnString = returnString + "Type: FCS Event";
        }
        if (this.eventDetails == 51) {
            returnString = returnString + ",Details: Machine Added";
        } else if (this.eventDetails == 52) {
            returnString = returnString + ",Details: Machine Removed";
        } else if (this.eventDetails == 53) {
            returnString = returnString + ",Details: Machine Recycled";
        } else if (this.eventDetails == 54) {
            returnString = returnString + ",Details: Machine Changed";
        } else if (this.eventDetails == 100) {
            returnString = returnString + ",Details: Service Added";
        } else if (this.eventDetails == 101) {
            returnString = returnString + ",Details: Service Removed";
        } else if (this.eventDetails == 150) {
            returnString = returnString + ",Details: FCS Server Stopped";
        } else if (this.eventDetails == 151) {
            returnString = returnString + ",Details: FCS Server Restarted";
        }
        returnString = returnString + ",Source Machine: " + this.machineId;
        if (this.oldMachineId != null) {
            returnString = returnString + ",Old Source Machine ID: " + this.oldMachineId;
        }
        returnString = returnString + ",Service List: ";
        if (this.services == null) {
            returnString = returnString + "null";
        } else {
            Iterator iterator = this.services.iterator();
            while (iterator.hasNext()) {
                returnString = returnString + (FcsServiceId)iterator.next() + ",";
            }
        }
        return returnString;
    }
}

